
const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;
#define vec2 float2
#define vec3 float3
#define vec4 float4

vec4 Screen(vec4 base, vec4 blend)
{
    vec4 white = (vec4)(1.0f);
    vec4 result = white - ((white - blend) * (white - base));
    return result;
}

vec3 refract(vec3 I, vec3 N, float eta)
{
	float k = 1.0f - eta * eta * (1.0f - dot(N, I) * dot(N, I));
    if (k < 0.0f)
        return (vec3)(0.0f);
    else
        return eta * I - (eta * dot(N, I) + sqrt(k)) * N;
}

vec4 INPUTSRC(image2d_t src_data,__global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, tc);
}

vec4 INPUT(image2d_t src_data, __global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, tc);
}

//Author: RuanShengQiang
__kernel void MAIN(__read_only image2d_t input1, __read_only image2d_t input2, __write_only image2d_t dest_data,__global FilterParam* param, float radius, int alpha)
{
	int W = get_global_size(0);
	int H = get_global_size(1);
	int textH = param->height[0];;
	float iGlobalTime = param->cur_time / param->total_time;
	
	int w = get_global_id(0);
	int h = get_global_id(1);
	float2 iresolution = (float2)(W,H);
	int2 gl_FragCoord = (int2)(get_global_id(0), get_global_id(1));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 tc = (vec2)(fragCoord.x + 0.5f, fragCoord.y + 0.5f)/iresolution.xy;
	
	vec2 u_imgWH = iresolution;
    vec2 u_center = (vec2)(0.5f);              //normalized coord
    float u_radius = 0.25f + 0.25f * (radius);
	float u_aspectRatio = u_imgWH.y / u_imgWH.x;
    float u_refractiveIndex = 0.75f;
    
    vec2 textureCoordinateToUse = (vec2)(tc.x, (tc.y * u_aspectRatio + 0.5f - 0.5f * u_aspectRatio));
    
    float distanceFromCenter = distance(u_center, textureCoordinateToUse);
    float checkForPresenceWithinSphere = step(distanceFromCenter, u_radius);
    
    distanceFromCenter = distanceFromCenter / u_radius;
    
    float normalizedDepth = u_radius * sqrt(1.0f - distanceFromCenter * distanceFromCenter);
    vec3 sphereNormal = normalize((vec3)(textureCoordinateToUse - u_center, normalizedDepth));
    
    vec3 refractedVector = 2.0f*refract((vec3)(0.0f, 0.0f, -1.0f), sphereNormal, u_refractiveIndex);
    refractedVector = -refractedVector;
    
    vec4 baseLay = INPUTSRC(input1, param, (refractedVector.xy + 1.0f) * 0.5f) * checkForPresenceWithinSphere;
    
    vec2 upTexCoord = (vec2)(tc.x, tc.y * u_aspectRatio + 0.5f - 0.5f * u_aspectRatio);
    float texScale = 0.5f / u_radius;
    upTexCoord = (upTexCoord - u_center) * texScale + u_center;
    vec4 upLay = INPUT(input2, param, upTexCoord);
   
    //vec4 upLay = INPUT(input2, param, tc);
    vec4 color  = baseLay * (1.0f - upLay.w) + upLay * upLay.w;
	vec4 orig = INPUTSRC(input1, param, tc);
	color.w = orig.w;
	vec4 tuneCol = color;
	
	float4 outputCol = (float4)(orig.xyz*(1.0f - (float)alpha/100.0f) + tuneCol.xyz*(float)alpha/100.0f, orig.w);
	
	write_imagef(dest_data, gl_FragCoord, outputCol); 
}
